# small-caps refers to cifar-style models i.e., resnet18 -> for cifar vs ResNet18 -> standard arch.
from models.vgg_cifar import (
    vgg16,
    vgg16_bn,
)

from models.vgg_cifar_silu import vgg16_bn_silu
from models.vgg_cifar_dense import vgg16_bn_dense
from models.vit import prunable_vit_tiny_cifar10, prunable_vit_small_cifar10, prunable_vit_base_cifar10
from models.resnet_cifar import resnet18, resnet34, resnet50, resnet101, resnet152

from models.resnet_cifar_silu import resnet18_silu
from models.wrn_cifar import wrn_28_10, wrn_28_1, wrn_28_4, wrn_34_10, wrn_40_2
from models.wrn_cifar_silu import wrn_28_4_silu

from models.basic import (
    lin_1,
    lin_2,
    lin_3,
    lin_4,
    mnist_model,
    mnist_model_large,
    cifar_model,
    cifar_model_large,
    cifar_model_resnet,
    vgg4_without_maxpool,
)

from models.resnet import ResNet18, ResNet34, ResNet50
from models.resnet_silu import ResNet18_silu, ResNet34_silu, ResNet50_silu
from models.dense_resnet_cifar import resnet18_dense
from models.dense_resnet_silu_cifar import resnet18_silu_dense


__all__ = [
    "vgg16",
    "vgg16_bn",
    "vgg16_bn_dense",
    "vgg16_bn_silu",
    "resnet18",
    "resnet18_silu"
    "resnet18_dense", 
    "resnet18_silu_dense"
    "resnet34",
    "resnet50",
    "resnet101",
    "resnet152",
    "wrn_28_10",
    "wrn_28_1",
    "wrn_28_4",
    "wrn_28_4_silu",
    "wrn_28_4_silu_dense",
    "prunable_vit_tiny_cifar10",
    "prunable_vit_small_cifar10", 
    "prunable_vit_base_cifar10",
    "wrn_34_10",
    "wrn_40_2",
    "lin_1",
    "lin_2",
    "lin_3",
    "lin_4",
    "mnist_model",
    "mnist_model_large",
    "cifar_model",
    "cifar_model_large",
    "cifar_model_resnet",
    "vgg4_without_maxpool",
    "ResNet18",
    "ResNet34",
    "ResNet50",
    "ResNet18_silu",
    "ResNet34_silu",
    "ResNet50_silu"
]
